<?php

use WCBT\Helpers\Fields\Checkbox;
use WCBT\Helpers\Fields\ColorPicker;
use WCBT\Helpers\Fields\FileUpload;
use WCBT\Helpers\Fields\Number;
use WCBT\Helpers\Fields\Select;
use WCBT\Helpers\Fields\Text;
use WCBT\Helpers\Fields\Textarea;
use WCBT\Helpers\Fields\WPDropdownPage;
use WCBT\Helpers\Fields\Radio;
use WCBT\Helpers\Settings;
use WCBT\Models\ProductAttributeModel;

//$attributes = wc_get_attribute_taxonomies();
$attributes = ProductAttributeModel::get_attribute_taxonomies();

$attribute_options = array();

foreach ( $attributes as $key => $value ) {
	$name = 'pa_' . $value->attribute_name;
	$attribute_options[$name] = array(
		'id'    => $name,
		'label' => $value->attribute_label
	);
}

return apply_filters(
	'wcbt/filter/config/setting/fields',
	array(
		'setting'        => array(
			'id'    => 'setting',
			'slug'  => 'wcbt-setting',
			'title' => esc_html__( 'Woo Booster Toolkit', 'wcbt' ),
		),
		'wishlist'       => array(
			'id'     => 'wishlist',
			'slug'   => 'wcbt-wishlist',
			'title'  => esc_html__( 'WishList', 'wcbt' ),
			'fields' => array(
				'enable'              => array(
					'type'    => new Checkbox(),
					'id'      => 'wishlist_enable',
					'title'   => esc_html__( 'Mode', 'wcbt' ),
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'class'   => 'col-12',
					'default' => '',
				),
				'page'                => array(
					'type'              => new WPDropdownPage(),
					'id'                => 'wishlist_page',
					'title'             => esc_html__( 'Page', 'wcbt' ),
					'class'             => 'col-12 hide',
					'args'              => array(
						'id'                => 'wcbt_wishlist_page',
						'name'              => 'page',
						'class'             => 'wcbt-tom-select',
						'option_none_value' => '',
						'show_option_none'  => 'Select a page',
						'sort_column'       => 'date',
					),
					'allow_create_page' => true,
					'default'           => '',
				),
				//              'icon_color'             => array(
				//                  'type'    => new ColorPicker(),
				//                  'id'      => 'wishlist_icon_color',
				//                  'title'   => esc_html__( 'Icon Color', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '#904141',
				//              ),
				//              'background_color'       => array(
				//                  'type'    => new ColorPicker(),
				//                  'id'      => 'wishlist_background_color',
				//                  'title'   => esc_html__( 'Background Color', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '#904141',
				//              ),
				//              'icon_hover_color'       => array(
				//                  'type'    => new ColorPicker(),
				//                  'id'      => 'wishlist_icon_hover_color',
				//                  'title'   => esc_html__( 'Icon Hover Color', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '#904141',
				//              ),
				//              'background_hover_color' => array(
				//                  'type'    => new ColorPicker(),
				//                  'id'      => 'wishlist_background_hover_color',
				//                  'title'   => esc_html__( 'Background Hover Color', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '#904141',
				//              ),
				//              'layout'                 => array(
				//                  'type'    => new Select(),
				//                  'id'      => 'wishlist_layout',
				//                  'title'   => esc_html__( 'Layout', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'options' => array(
				//                      'grid' => esc_html__( 'Grid', 'wcbt' ),
				//                      'list' => esc_html__( 'List', 'wcbt' ),
				//                  ),
				//                  'default' => 'grid',
				//              ),
				//              'number_grid_columns'    => array(
				//                  'type'     => new Number(),
				//                  'step'     => 1,
				//                  'id'       => 'wishlist_number_grid_columns',
				//                  'title'    => esc_html__( 'Number Grid Columns', 'wcbt' ),
				//                  'min'      => 1,
				//                  'class'    => 'col-12 hide',
				//                  'default'  => 10,
				//                  'required' => true,
				//              ),
				'tooltip_enable'      => array(
					'type'    => new Checkbox(),
					'id'      => 'wishlist_tooltip_enable',
					'title'   => esc_html__( 'Tooltip', 'wcbt' ),
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'class'   => 'col-12 hide',
					'default' => '',
				),
				'tooltip_text'        => array(
					'type'    => new Text(),
					'id'      => 'wishlist_tooltip_text',
					'title'   => esc_html__( 'Add WishList Tooltip Text', 'wcbt' ),
					'class'   => 'col-12 hide',
					'default' => 'Add Wishlist',
				),
				'remove_tooltip_text' => array(
					'type'    => new Text(),
					'id'      => 'wishlist_remove_tooltip_text',
					'title'   => esc_html__( 'Remove WishList Tooltip Text', 'wcbt' ),
					'class'   => 'col-12 hide',
					'default' => 'Remove Wishlist',
				),
				'type'                => array(
					'type'    => new Select(),
					'id'      => 'wishlist_type',
					'title'   => esc_html__( 'WishList Type', 'wcbt' ),
					'class'   => 'col-12 hide',
					'options' => array(
						'square' => esc_html__( 'Square', 'wcbt' ),
						'circle' => esc_html__( 'Circle', 'wcbt' ),
					),
					'default' => 'square',
				),
			),
		),
		'compare'        => array(
			'id'     => 'compare',
			'slug'   => 'wcbt-compare',
			'title'  => esc_html__( 'Compare', 'wcbt' ),
			'fields' => array(
				'enable'              => array(
					'type'    => new Checkbox(),
					'id'      => 'compare_enable',
					'title'   => esc_html__( 'Mode', 'wcbt' ),
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'class'   => 'col-12',
					'default' => '',
				),
				'page'                => array(
					'type'              => new WPDropdownPage(),
					'id'                => 'compare_page',
					'title'             => esc_html__( 'Page', 'wcbt' ),
					'class'             => 'col-12 hide',
					'args'              => array(
						'id'                => 'wcbt_compare_page',
						'name'              => 'page',
						'class'             => 'wcbt-tom-select',
						'option_none_value' => '',
						'show_option_none'  => 'Select a page',
						'sort_column'       => 'date',
					),
					'allow_create_page' => true,
					'default'           => '',
				),
				//              'icon_color'             => array(
				//                  'type'    => new ColorPicker(),
				//                  'id'      => 'compare_icon_color',
				//                  'title'   => esc_html__( 'Icon Color', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '#904141',
				//              ),
				//              'background_color'       => array(
				//                  'type'    => new ColorPicker(),
				//                  'id'      => 'compare_background_color',
				//                  'title'   => esc_html__( 'Background Color', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '#904141',
				//              ),
				//              'icon_hover_color'       => array(
				//                  'type'    => new ColorPicker(),
				//                  'id'      => 'compare_icon_hover_color',
				//                  'title'   => esc_html__( 'Icon Hover Color', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '#904141',
				//              ),
				//              'background_hover_color' => array(
				//                  'type'    => new ColorPicker(),
				//                  'id'      => 'compare_background_hover_color',
				//                  'title'   => esc_html__( 'Background Hover Color', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '#904141',
				//              ),
				//              'layout'                 => array(
				//                  'type'    => new Select(),
				//                  'id'      => 'compare_layout',
				//                  'title'   => esc_html__( 'Layout', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'options' => array(
				//                      'grid' => esc_html__( 'Grid', 'wcbt' ),
				//                      'list' => esc_html__( 'List', 'wcbt' ),
				//                  ),
				//                  'default' => 'grid',
				//              ),
				//              'number_grid_columns'    => array(
				//                  'type'     => new Number(),
				//                  'step'     => 1,
				//                  'id'       => 'compare_number_grid_columns',
				//                  'title'    => esc_html__( 'Number Grid Columns', 'wcbt' ),
				//                  'min'      => 1,
				//                  'class'    => 'col-12 hide',
				//                  'default'  => 10,
				//                  'required' => true,
				//              ),
				'tooltip_enable'      => array(
					'type'    => new Checkbox(),
					'id'      => 'compare_tooltip_enable',
					'title'   => esc_html__( 'Tooltip', 'wcbt' ),
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'class'   => 'col-12 hide',
					'default' => '',
				),
				'tooltip_text'        => array(
					'type'    => new Text(),
					'id'      => 'compare_tooltip_text',
					'title'   => esc_html__( 'Add Compare Tooltip Text', 'wcbt' ),
					'class'   => 'col-12 hide',
					'default' => 'Add Compare',
				),
				'remove_tooltip_text' => array(
					'type'    => new Text(),
					'id'      => 'compare_remove_tooltip_text',
					'title'   => esc_html__( 'Remove Compare Tooltip Text', 'wcbt' ),
					'class'   => 'col-12 hide',
					'default' => 'Remove Compare',
				),
				'type'                => array(
					'type'    => new Select(),
					'id'      => 'compare_type',
					'title'   => esc_html__( 'Compare Type', 'wcbt' ),
					'class'   => 'col-12 hide',
					'options' => array(
						'square' => esc_html__( 'Square', 'wcbt' ),
						'circle' => esc_html__( 'Circle', 'wcbt' ),
					),
					'default' => 'square',
				),
			),
		),
		'quick-view'     => array(
			'id'     => 'quick-view',
			'slug'   => 'wcbt-quick-view',
			'title'  => esc_html__( 'Quick View', 'wcbt' ),
			'fields' => array(
				'enable'         => array(
					'type'    => new Checkbox(),
					'id'      => 'quick_view_enable',
					'title'   => esc_html__( 'Mode', 'wcbt' ),
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'class'   => 'col-12',
					'default' => '',
				),
				//              'icon_color'             => array(
				//                  'type'    => new ColorPicker(),
				//                  'id'      => 'quick_view_icon_color',
				//                  'title'   => esc_html__( 'Icon Color', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '#904141',
				//              ),
				//              'background_color'       => array(
				//                  'type'    => new ColorPicker(),
				//                  'id'      => 'quick_view_background_color',
				//                  'title'   => esc_html__( 'Background Color', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '#904141',
				//              ),
				//              'icon_hover_color'       => array(
				//                  'type'    => new ColorPicker(),
				//                  'id'      => 'quick_view_icon_hover_color',
				//                  'title'   => esc_html__( 'Icon Hover Color', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '#904141',
				//              ),
				//              'background_hover_color' => array(
				//                  'type'    => new ColorPicker(),
				//                  'id'      => 'quick_view_background_hover_color',
				//                  'title'   => esc_html__( 'Background Hover Color', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '#904141',
				//              ),
				//              'hide_mobile'            => array(
				//                  'type'    => new Checkbox(),
				//                  'id'      => 'quick_view_hide_mobile',
				//                  'title'   => esc_html__( 'Hide On Mobile', 'wcbt' ),
				//                  'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '',
				//              ),
				//              'hide_tablet'            => array(
				//                  'type'    => new Checkbox(),
				//                  'id'      => 'quick_view_hide_tablet',
				//                  'title'   => esc_html__( 'Hide On Tablet', 'wcbt' ),
				//                  'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '',
				//              ),
				'tooltip_enable' => array(
					'type'    => new Checkbox(),
					'id'      => 'quick_view_tooltip_enable',
					'title'   => esc_html__( 'Tooltip', 'wcbt' ),
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'class'   => 'col-12 hide',
					'default' => '',
				),
				'tooltip_text'   => array(
					'type'    => new Text(),
					'id'      => 'quick_view_tooltip_text',
					'title'   => esc_html__( 'Tooltip Text', 'wcbt' ),
					'class'   => 'col-12 hide',
					'default' => 'Quick View',
				),
				'type'           => array(
					'type'    => new Select(),
					'id'      => 'quick_view_type',
					'title'   => esc_html__( 'Quick View Type', 'wcbt' ),
					'class'   => 'col-12 hide',
					'options' => array(
						'square' => esc_html__( 'Square', 'wcbt' ),
						'circle' => esc_html__( 'Circle', 'wcbt' ),
					),
					'default' => 'square',
				),
				'product_image_width'           => array(
					'type'    => new Number(),
					'id'      => 'product_image_width',
					'title'   => esc_html__( 'Product Image Width (px)', 'wcbt' ),
					'default' => 500,
					'class'   => 'col-12 hide',
				),
				'product_image_height'           => array(
					'type'    => new Number(),
					'id'      => 'product_image_height',
					'title'   => esc_html__( 'Product Image Height (px)', 'wcbt' ),
					'default' => 500,
					'class'   => 'col-12 hide',
				),
			),
		),
		'variation'      => array(
			'id'     => 'variation',
			'slug'   => 'wcbt-variation',
			'title'  => esc_html__( 'Variation', 'wcbt' ),
			'fields' => array(
				'enable'                  => array(
					'type'    => new Checkbox(),
					'id'      => 'variation_enable',
					'title'   => esc_html__( 'Mode', 'wcbt' ),
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'class'   => 'col-12',
					'default' => '',
				),
//                'display_on_single_product' => array(
//                    'type'    => new Checkbox(),
//                    'id'      => 'display_on_single_product',
//                    'title'   => esc_html__('Display on Single Product', 'wcbt'),
//                    'label'   => esc_html__('Enable/Disable', 'wcbt'),
//                    'class'   => 'col-12',
//                    'default' => '',
//                ),
				'display_on_product_list' => array(
					'type'    => new Checkbox(),
					'id'      => 'display_on_product_list',
					'title'   => esc_html__( 'Display on Product List', 'wcbt' ),
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'class'   => 'col-12',
					'default' => '',
				),
				'show-selected-name'      => array(
					'type'    => new Checkbox(),
					'id'      => 'show-selected-name',
					'title'   => esc_html__( 'Show Selected Name', 'wcbt' ),
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'class'   => 'col-12',
					'default' => '',
				),
				//              'visible_in_single_product' => array(
				//                  'type'    => new Checkbox(),
				//                  'id'      => 'variation_visible_in_single_product',
				//                  'title'   => esc_html__( 'Visible in Single Product Page', 'wcbt' ),
				//                  'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '',
				//              ),
				//              'visible_in_shop_page'      => array(
				//                  'type'    => new Checkbox(),
				//                  'id'      => 'variation_visible_in_shop_page',
				//                  'title'   => esc_html__( 'Visible in Shop Page', 'wcbt' ),
				//                  'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '',
				//              ),
				//              'visible_in_quick_view'     => array(
				//                  'type'    => new Checkbox(),
				//                  'id'      => 'variation_visible_in_quick_view',
				//                  'title'   => esc_html__( 'Visible in Quick View', 'wcbt' ),
				//                  'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '',
				//              ),
				//              'hide_mobile'               => array(
				//                  'type'    => new Checkbox(),
				//                  'id'      => 'quick_hide_mobile',
				//                  'title'   => esc_html__( 'Hide On Mobile', 'wcbt' ),
				//                  'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '',
				//              ),
				//              'hide_tablet'               => array(
				//                  'type'    => new Checkbox(),
				//                  'id'      => 'quick_hide_tablet',
				//                  'title'   => esc_html__( 'Hide On Tablet', 'wcbt' ),
				//                  'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'default' => '',
				//              ),
				//              'type'                      => array(
				//                  'type'    => new Select(),
				//                  'id'      => 'variation_type',
				//                  'title'   => esc_html__( 'Variation Type', 'wcbt' ),
				//                  'class'   => 'col-12 hide',
				//                  'options' => array(
				//                      'square' => esc_html__( 'Square', 'wcbt' ),
				//                      'circle' => esc_html__( 'Circle', 'wcbt' ),
				//                  ),
				//                  'default' => 'square',
				//              ),
				//              'padding_top'               => array(
				//                  'type'     => new Number(),
				//                  'id'       => 'variation_padding_top',
				//                  'title'    => esc_html__( 'Padding Top(px)', 'wcbt' ),
				//                  'class'    => 'col-12 hide',
				//                  'min'      => 0,
				//                  'default'  => 20,
				//                  'required' => true,
				//              ),
				//              'padding_bottom'            => array(
				//                  'type'     => new Number(),
				//                  'id'       => 'variation_padding_bottom',
				//                  'title'    => esc_html__( 'Padding Bottom(px)', 'wcbt' ),
				//                  'class'    => 'col-12 hide',
				//                  'min'      => 0,
				//                  'default'  => 20,
				//                  'required' => true,
				//              ),
				//              'padding_left'              => array(
				//                  'type'     => new Number(),
				//                  'id'       => 'variation_padding_left',
				//                  'title'    => esc_html__( 'Padding Left(px)', 'wcbt' ),
				//                  'class'    => 'col-12 hide',
				//                  'min'      => 0,
				//                  'default'  => 20,
				//                  'required' => true,
				//              ),
				//              'padding_right'             => array(
				//                  'type'     => new Number(),
				//                  'id'       => 'variation_padding_right',
				//                  'title'    => esc_html__( 'Padding Right(px)', 'wcbt' ),
				//                  'class'    => 'col-12 hide',
				//                  'min'      => 0,
				//                  'default'  => 20,
				//                  'required' => true,
				//              ),
				//              'margin_top'                => array(
				//                  'type'     => new Number(),
				//                  'id'       => 'variation_margin_top',
				//                  'title'    => esc_html__( 'Margin Top(px)', 'wcbt' ),
				//                  'class'    => 'col-12 hide',
				//                  'min'      => 0,
				//                  'default'  => 20,
				//                  'required' => true,
				//              ),
				//              'margin_bottom'             => array(
				//                  'type'     => new Number(),
				//                  'id'       => 'variation_margin_bottom',
				//                  'title'    => esc_html__( 'Margin Bottom(px)', 'wcbt' ),
				//                  'class'    => 'col-12 hide',
				//                  'min'      => 0,
				//                  'default'  => 20,
				//                  'required' => true,
				//              ),
				//              'margin_left'               => array(
				//                  'type'     => new Number(),
				//                  'id'       => 'variation_margin_left',
				//                  'title'    => esc_html__( 'Margin Left(px)', 'wcbt' ),
				//                  'class'    => 'col-12 hide',
				//                  'min'      => 0,
				//                  'default'  => 20,
				//                  'required' => true,
				//              ),
				//              'margin_right'              => array(
				//                  'type'     => new Number(),
				//                  'id'       => 'variation_margin_right',
				//                  'title'    => esc_html__( 'Margin Right(px)', 'wcbt' ),
				//                  'class'    => 'col-12 hide',
				//                  'min'      => 0,
				//                  'default'  => 20,
				//                  'required' => true,
				//              ),
			),
		),
		'maxsale-popup'  => array(
			'id'     => 'maxsale-popup',
			'slug'   => 'wcbt-maxsale-popup',
			'title'  => esc_html__( 'MaxSale Popup', 'wcbt' ),
			'fields' => array(
				'enable'           => array(
					'type'    => new Checkbox(),
					'id'      => 'maxsale_popup_enable',
					'title'   => esc_html__( 'Mode', 'wcbt' ),
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'class'   => 'col-12',
					'default' => '',
				),
//                'goal'                    => array(
//                    'type'    => new Radio(),
//                    'id'      => 'goal',
//                    'title'   => esc_html__('Goal for Popup', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                    'options' => array(
//                        'collect_leads' => array(
//                            'label' => esc_html__('Collect leads', 'wcbt'),
//                            'id'    => 'collect_leads',
//                        ),
//                        'discount_code' => array(
//                            'label' => esc_html__('Give a discount code', 'wcbt'),
//                            'id'    => 'discount_code',
//                        ),
//                        'get_discount'  => array(
//                            'label' => esc_html__('Subscribe to get discount', 'wcbt'),
//                            'id'    => 'get_discount',
//                        ),
//                        'announcement'  => array(
//                            'label' => esc_html__('Announcement', 'wcbt'),
//                            'id'    => 'announcement',
//                        ),
//                    ),
//                    'default' => 'collect_leads',
//                ),
				'title'            => array(
					'type'    => new Text(),
					'id'      => 'title',
					'title'   => esc_html__( 'Title', 'wcbt' ),
					'default' => esc_html__( 'Special gift for our subscriber title', 'wcbt' ),
					'class'   => 'col-12 hide',
				),
				'description'      => array(
					'type'        => new Textarea(),
					'id'          => 'description',
					'title'       => esc_html__( 'Description', 'wcbt' ),
					'description' => esc_html__( 'Each user is separated by a comma.', 'wcbt' ),
					'class'       => 'col-12 hide',
					'sanitize'    => 'html',
					'default'     => esc_html__( 'Enter your email to get 50% off for all products.', 'wcbt' ),
				),

//                'button'                  => array(
//                    'type'    => new Text(),
//                    'id'      => 'button',
//                    'title'   => esc_html__('Button', 'wcbt'),
//                    'default' => esc_html__('Get my 20% off', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                ),
//                'email_placeholder'       => array(
//                    'type'    => new Text(),
//                    'id'      => 'email_placeholder',
//                    'title'   => esc_html__('Email placeholder', 'wcbt'),
//                    'default' => 'example@gmail.com',
//                    'class'   => 'col-12 hide',
//                ),
				//                'template'            => array(
				//                    'type'    => new Radio(),
				//                    'id'      => 'template',
				//                    'title'   => esc_html__('Pick a template', 'wcbt'),
				//                    'class'   => 'col-12 hide',
				//                    'options' => array(
				//                        'template_1' => array(
				//                            'label' => esc_html__('Template 1', 'wcbt'),
				//                            'id'    => 'template_1',
				//                        ),
				//                        'template_2' => array(
				//                            'label' => esc_html__('Template 2', 'wcbt'),
				//                            'id'    => 'template_2',
				//                        ),
				//                        'template_3' => array(
				//                            'label' => esc_html__('Template 3', 'wcbt'),
				//                            'id'    => 'template_3',
				//                        ),
				//                    ),
				//                    'default' => 'template_1',
				//                ),
				'background_color' => array(
					'name'    => 'background_color',
					'type'    => new ColorPicker(),
					'id'      => 'background_color',
					'title'   => esc_html__( 'Background Color', 'wcbt' ),
					'default' => '#904141',
					'class'   => 'col-12 hide',
				),
				'text_color'       => array(
					'name'    => 'text_color',
					'type'    => new ColorPicker(),
					'id'      => 'text_color',
					'title'   => esc_html__( 'Text Color', 'wcbt' ),
					'default' => '#904141',
					'class'   => 'col-12 hide',
				),
//                'button_text_color'       => array(
//                    'name'    => 'button_text_color',
//                    'type'    => new ColorPicker(),
//                    'id'      => 'button_color',
//                    'title'   => esc_html__('Button Text Color', 'wcbt'),
//                    'default' => '#904141',
//                    'class'   => 'col-12 hide',
//                ),
//                'button_background_color' => array(
//                    'name'    => 'button_background_color',
//                    'type'    => new ColorPicker(),
//                    'id'      => 'color',
//                    'title'   => esc_html__('Button Background Color', 'wcbt'),
//                    'default' => '#904141',
//                    'class'   => 'col-12 hide',
//                ),
				'image'            => array(
					'type'         => new FileUpload(),
					'id'           => 'image',
					'name'         => 'image',
					'title'        => esc_html__( 'Image', 'wcbt' ),
					'button_title' => esc_html__( 'Select Image', 'wcbt' ),
					'class'        => 'col-12 hide',
					'default'      => '',
					'multiple'     => false,
				),
				//                'open'                => array(
				//                    'type'    => new Radio(),
				//                    'id'      => 'open',
				//                    'title'   => esc_html__('Trigger open automatically', 'wcbt'),
				//                    'class'   => 'col-12 hide',
				//                    'options' => array(
				//                        'after_page_loaded'    => array(
				//                            'label' => esc_html__('After page loaded', 'wcbt'),
				//                            'id'    => 'after_page_loaded',
				//                        ),
				//                        'after_specific_time'  => array(
				//                            'label' => esc_html__('After specific time', 'wcbt'),
				//                            'id'    => 'after_specific_time',
				//                        ),
				//                        'after_scrolling_down' => array(
				//                            'label' => esc_html__('After scrolling down', 'wcbt'),
				//                            'id'    => 'after_scrolling_down',
				//                        ),
				//                    ),
				//                    'default' => 'after_page_loaded',
				//                ),
				//                'after_specific_time' => array(
				//                    'type'    => new Number(),
				//                    'id'      => 'after_specific_time',
				//                    'title'   => esc_html__('Time(s)', 'wcbt'),
				//                    'default' => 10,
				//                    'class'   => 'col-12 hide',
				//                ),
				'display_on'       => array(
					'type'    => new Radio(),
					'id'      => 'display_on',
					'title'   => esc_html__( 'Display on', 'wcbt' ),
					'class'   => 'col-12 hide',
					'options' => array(
						'all'           => array(
							'label' => esc_html__( 'All pages', 'wcbt' ),
							'id'    => 'display_on_all',
						),
						'homepage_only' => array(
							'label' => esc_html__( 'Home page only', 'wcbt' ),
							'id'    => 'homepage_only',
						),
					),
					'default' => 'all',
				),
				'repeat_open'      => array(
					'type'    => new Checkbox(),
					'id'      => 'repeat_open',
					'title'   => esc_html__( 'Repeat open automatically', 'wcbt' ),
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'class'   => 'col-12 hide',
					'default' => '',
				),
				'repeat_open_time' => array(
					'type'        => new Number(),
					'id'          => 'repeat_open_time',
					'title'       => esc_html__( 'Time (hour)', 'wcbt' ),
					'min'         => 0,
					'default'     => 10,
					'description' => esc_html__( 'Stop automatically showing this popup to customers who have already 
                    converted or closed popup.', 'wcbt' ),
					'class'       => 'col-12 hide',
				),
			)
		),
		'product-filter' => array(
			'id'     => 'product-filter',
			'slug'   => 'wcbt-product-filter',
			'title'  => esc_html__( 'Product Filter', 'wcbt' ),
			'fields' => array(
				'enable'                => array(
					'type'    => new Checkbox(),
					'id'      => 'product_filter_enable',
					'title'   => esc_html__( 'Mode', 'wcbt' ),
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'class'   => 'col-12',
					'default' => '',
				),
				'product-filter'        => array(
					'title'    => esc_html__( 'Product Filter', 'wcbt' ),
					'type'     => new Checkbox(),
					'multiple' => true,
					'sortable' => true,
					'class'    => 'col-12 hide',
					'options'  => array_merge(
						array(
							'availability' => array(
								'id'    => 'availability',
								'label' => esc_html__( 'Availability', 'wcbt' ),
							),
							'category'     => array(
								'id'    => 'category',
								'label' => esc_html__( 'Category', 'wcbt' ),
							),
							'price'        => array(
								'id'    => 'price',
								'label' => esc_html__( 'Price', 'wcbt' ),
							),
							'rating'       => array(
								'id'    => 'rating',
								'label' => esc_html__( 'Rating', 'wcbt' ),
							),
						),
						$attribute_options
					),
					'default'  => array(),
				),
				'category_number'       => array(
					'type'    => new Number(),
					'id'      => 'category_number',
					'title'   => esc_html__( 'Category Number', 'wcbt' ),
					'min'     => 0,
					'class'   => 'col-12 hide',
					'default' => 10,
				),
				'attribute_term_number' => array(
					'type'    => new Number(),
					'id'      => 'attribute_term_number',
					'title'   => esc_html__( 'Attribute Term Number', 'wcbt' ),
					'min'     => 0,
					'class'   => 'col-12 hide',
					'default' => 10,
				),
				'min_price'             => array(
					'type'    => new Number(),
					'id'      => 'min_price',
					'title'   => esc_html__( 'Min Price', 'wcbt' ),
					'min'     => 0,
					'class'   => 'col-12 hide',
					'default' => 0,
				),
				'max_price'             => array(
					'type'    => new Number(),
					'id'      => 'max_price',
					'title'   => esc_html__( 'Max Price', 'wcbt' ),
					'min'     => 0,
					'class'   => 'col-12 hide',
					'default' => 250,
				),
				'step_price'            => array(
					'type'    => new Number(),
					'id'      => 'step_price',
					'title'   => esc_html__( 'Step Price', 'wcbt' ),
					'min'     => 1,
					'class'   => 'col-12 hide',
					'default' => 10,
				),
				'ajax_filter' => array(
					'type'    => new Checkbox(),
					'id'      => 'ajax_filter',
					'title'   => esc_html__( 'Ajax Filter', 'wcbt' ),
					'class'   => 'col-12 hide',
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'default' => 'on',
				),
			)
		),
//        'sale-notice'   => array(
//            'id'     => 'sale-notice',
//            'slug'   => 'wcbt-sale-notice',
//            'title'  => esc_html__('Sale Notice', 'wcbt'),
//            'fields' => array(
//                'enable'              => array(
//                    'type'    => new Checkbox(),
//                    'id'      => 'sale_notice_enable',
//                    'title'   => esc_html__('Mode', 'wcbt'),
//                    'label'   => esc_html__('Enable/Disable', 'wcbt'),
//                    'class'   => 'col-12',
//                    'default' => '',
//                ),
//                'type'                => array(
//                    'type'    => new Select(),
//                    'id'      => 'product_type',
//                    'title'   => esc_html__('Product Type', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                    'options' => array(
//                        'sale-product' => esc_html__('Sale Product', 'wcbt'),
//                        'virtual-product' => esc_html__('Virtual Product', 'wcbt'),
//                    ),
//                    'default' => 'sale-product',
//                ),
//    //                'time_close'          => array(
//    //                    'type'        => new Select(),
//    //                    'id'          => 'time_close',
//    //                    'title'       => esc_html__('Time Close(h)', 'wcbt'),
//    //                    'class'       => 'col-12 hide',
//    //                    'min'         => 0,
//    //                    'default'     => 24,
//    //                    'description' => esc_html__('Time display again after click close button.', 'wcbt')
//    //                ),
//                'sale_product_order'  => array(
//                    'type'    => new Select(),
//                    'id'      => 'sale_product_order',
//                    'title'   => esc_html__('Order', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                    'options' => array(
//                        'recent' => esc_html__('Recently', 'wcbt'),
//                        'random' => esc_html__('Randomly', 'wcbt'),
//                    ),
//                    'default' => 'recent',
//                ),
//                'sale_product_number' => array(
//                    'type'    => new Number(),
//                    'id'      => 'sale_product_number',
//                    'title'   => esc_html__('Number', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                    'min'     => 1,
//                    'default' => 5,
//                ),
//                'virtual_product'        => array(
//                    'type'          => new Select(),
//                    'id'            => 'virtual_product',
//                    'title'         => esc_html__('Virtual Product', 'wcbt'),
//                    'class'         => 'col-12 hide',
//                    'options'       => Settings::get_all_products(),
//                    'is_multiple'   => true,
//                    'is_tom_select' => true,
//                    'default'       => '',
//                ),
//                'virtual_user'                => array(
//                    'type'        => new Textarea(),
//                    'id'          => 'virtual_user',
//                    'title'       => esc_html__('Virtual User', 'wcbt'),
//                    'description' => esc_html__('Each user is separated by a comma.', 'wcbt'),
//                    'class'       => 'col-12 hide',
//                    'sanitize'    => 'html',
//                    'default'     => 'Jack,Paul,Alice, Emily,David'
//                ),
//                'position'            => array(
//                    'type'    => new Select(),
//                    'id'      => 'sale_notice_position',
//                    'title'   => esc_html__('Position', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                    'options' => array(
//                        'top_full_width'    => esc_html__('Top Full Width', 'wcbt'),
//                        'bottom_full_width' => esc_html__('Bottom Full Width', 'wcbt'),
//                        'top_left'          => esc_html__('Top Left', 'wcbt'),
//                        'top_right'         => esc_html__('Top Right', 'wcbt'),
//                        'bottom_left'       => esc_html__('Bottom Left', 'wcbt'),
//                        'bottom_right'      => esc_html__('Bottom Right', 'wcbt'),
//                    ),
//                    'default' => 'top_left',
//                ),
//                'close_button'        => array(
//                    'type'    => new Checkbox(),
//                    'id'      => 'close_button',
//                    'title'   => esc_html__('Close Button', 'wcbt'),
//                    'label'   => esc_html__('Enable/Disable', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                    'default' => '',
//                ),
//                'progress_bar'        => array(
//                    'type'    => new Checkbox(),
//                    'id'      => 'progress_bar',
//                    'title'   => esc_html__('Progress Bar', 'wcbt'),
//                    'label'   => esc_html__('Enable/Disable', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                    'default' => '',
//                ),
//                'text_color'          => array(
//                    'type'    => new ColorPicker(),
//                    'id'      => 'sale_notice_text_color',
//                    'title'   => esc_html__('Text Color', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                    'default' => '#904141',
//                ),
//                'background_color'    => array(
//                    'type'    => new ColorPicker(),
//                    'id'      => 'sale_notice_background_color',
//                    'title'   => esc_html__('Background Color', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                    'default' => '#904141',
//                ),
//                'image_position'      => array(
//                    'type'    => new Select(),
//                    'id'      => 'image_position',
//                    'title'   => esc_html__('Image Position', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                    'options' => array(
//                        'left'  => esc_html__('Left', 'wcbt'),
//                        'right' => esc_html__('Right', 'wcbt'),
//                    ),
//                    'default' => 'left',
//                ),
//                'message'             => array(
//                    'type'        => new Textarea(),
//                    'id'          => 'message',
//                    'title'       => esc_html__('Message', 'wcbt'),
//                    'description' => '<span>{{user_name}}</span><span>{{product}}</span>
//						<span>{{product_with_link}}</span><span>{{time_ago}}</span>',
//                    'class'       => 'col-12 hide',
//                    'sanitize'    => 'html',
//                    'default'     => '{{user_name}} purchased {{product}} {{time_ago}} minutes ago'
//                ),
//                'show_method'         => array(
//                    'type'    => new Select(),
//                    'id'      => 'show_method',
//                    'title'   => esc_html__('Show Method', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                    'options' => array(
//                        'fadeIn'    => esc_html__('fadeIn', 'wcbt'),
//                        'slideDown' => esc_html__('slideDown', 'wcbt'),
//                    ),
//                    'default' => 'fadeIn',
//                ),
//                'hide_method'         => array(
//                    'type'    => new Select(),
//                    'id'      => 'hide_method',
//                    'title'   => esc_html__('Hide Method', 'wcbt'),
//                    'class'   => 'col-12 hide',
//                    'options' => array(
//                        'fadeOut'   => esc_html__('fadeOut', 'wcbt'),
//                        'slideUp'   => esc_html__('slideUp', 'wcbt'),
//                    ),
//                    'default' => 'fadeIn',
//                ),
//                'show_duration'       => array(
//                    'type'     => new Number(),
//                    'id'       => 'show_duration',
//                    'title'    => esc_html__('Show Duration', 'wcbt'),
//                    'class'    => 'col-12 hide',
//                    'min'      => 0,
//                    'required' => true,
//                    'default'  => 300,
//                ),
//                'hide_duration'       => array(
//                    'type'     => new Number(),
//                    'id'       => 'hide_duration',
//                    'title'    => esc_html__('Hide Duration', 'wcbt'),
//                    'class'    => 'col-12 hide',
//                    'min'      => 0,
//                    'required' => true,
//                    'default'  => 1000,
//                ),
//                'timeout'             => array(
//                    'type'     => new Number(),
//                    'id'       => 'timeout',
//                    'title'    => esc_html__('Timeout', 'wcbt'),
//                    'class'    => 'col-12 hide',
//                    'min'      => 0,
//                    'required' => true,
//                    'default'  => 5000,
//                ),
//            )
//        ),
		'advanced'       => array(
			'id'     => 'advanced',
			'slug'   => 'wcbt-advanced',
			'title'  => esc_html__( 'Advanced', 'wcbt' ),
			'fields' => array(
				'debug_mode' => array(
					'type'    => new Checkbox(),
					'id'      => 'debug_mode',
					'title'   => esc_html__( 'Debug Mode', 'wcbt' ),
					'class'   => 'col-12',
					'label'   => esc_html__( 'Enable/Disable', 'wcbt' ),
					'default' => '',
				),
			)
		)
	)
);
